<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use Auth\Models\UserModel;
use App\Models\CategoryModel;
use App\Models\CustomModel;

use \Hermawan\DataTables\DataTable;


class CategoryController extends Controller
{

	public function __construct()
	{
		// start session
		$this->session = Services::session();

		// load auth settings
		$this->config = config('Auth');

		$this->categoryModel = new CategoryModel();
		$this->customModel = new CustomModel();


	}

    //--------------------------------------------------------------------

	/**
	 * Displays account settings.
	 */
	public function index()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}


		$get_category_list = '';

		return view('category/list', [
			'userData' => $this->session->userData,
		]);
	}


	public function listajaxDatatables()
	{
		$builder = $this->customModel->get_datatable_category();
    
    	return DataTable::of($builder)
			->add('status', function($row){
        			$status = "Inactive";
        			if($row->status == '1')
        			{
        				$status = "Active";
        			}
        			
        			return $status;
    			})
			->add('action', function($row){
        			$action = '<a href="'.base_url('editcategory/' . base64_encode($row->id)).'">Edit</a>/';
        			$action .= '<a href="#" id="deleteCategory" data-id="'.base64_encode($row->id).'">Delete</a>';
        			return $action;
    			})
			->addNumbering('no') 
    		->toJson(true);
	}


	public function add()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		

		if($this->request->getPost())
		{
			//insert here
			$getStatus = 0;
			if($this->request->getPost('status'))
			{
				$getStatus = 1;
			}

			$insertData = array(
				'category_name' => $this->request->getPost('category'),
				'status' => $getStatus,
				'date_created' => date('Y-m-d H:i:s'),
			);

			$this->categoryModel->insert($insertData);

			$this->session->setFlashdata('success_message', 'Record Added Successfully');
			return redirect()->to('category');
		}


		return view('category/add', [
			'userData' => $this->session->userData,
		]);
	}

	public function edit($id)
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		$id = base64_decode($id);
		$record = $this->categoryModel->find($id);

		if($this->request->getPost())
		{
			//insert here
			$getStatus = 0;
			if($this->request->getPost('status'))
			{
				$getStatus = 1;
			}

			$updateData = array(
				'category_name' => $this->request->getPost('category'),
				'status' => $getStatus,
			);

			$this->categoryModel->update($id,$updateData);

			$this->session->setFlashdata('success_message', 'Record Updated Successfully');
			return redirect()->to('category');
		}


		return view('category/edit', [
			'userData' => $this->session->userData,
			'record' => $record
		]);
	}


	public function delete($id)
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		$id = base64_decode($id);
		$record = $this->categoryModel->find($id);

		$updateData = array(
			'is_deleted' => '1'
		);

		$this->categoryModel->update($id,$updateData);

		$this->session->setFlashdata('success_message', 'Record Updated Successfully');
		return redirect()->to('category');
		

	}

}
