<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use Auth\Models\UserModel;
use App\Models\CategoryModel;
use App\Models\SubcategoryModel;
use App\Models\VideoModel;
use App\Models\TagsModel;
use App\Models\CustomModel;
use \Hermawan\DataTables\DataTable;


class VideoController extends Controller
{

	public function __construct()
	{
		// start session
		$this->session = Services::session();
		// load auth settings
		$this->config = config('Auth');
		$this->categoryModel = new CategoryModel();
		$this->subcategoryModel = new SubcategoryModel();
		$this->videoModel = new VideoModel();
		$this->tagsModel = new TagsModel();
		$this->customModel = new CustomModel();
	}


	/**
	 * Displays account settings.
	 */
	public function index()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		return view('video/list', [
			'userData' => $this->session->userData,
			'config' => $this->config
		]);
	}

	public function videolistajaxDatatables()
	{
		$builder = $this->customModel->get_datatable_videolist();
    
    	return DataTable::of($builder)
			->add('status', function($row){
        			$status = "Inactive";
        			if($row->status == '1')
        			{
        				$status = "Active";
        			}
        			
        			return $status;
    			})
			->add('action', function($row){
        			$action = '<a href="'.base_url('edit-video/' . base64_encode($row->id)).'">Edit</a>/';
        			$action .= '<a href="#" id="delete_video" data-id="'.base64_encode($row->id).'">Delete</a>';
        			return $action;
    			})
			->addNumbering('no') 
    		->toJson(true);
	}

	public function add()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		if($this->request->getPost())
		{
			//insert here
			$insertData = array(
				'video_url' => $this->request->getPost('videourl'),
				'title' => $this->request->getPost('title'),
				'video_description' => $this->request->getPost('about_video'),
				'category_id' => $this->request->getPost('category'),
				'sub_category' => $this->request->getPost('sub_category'),
				'date_created' => date('Y-m-d H:i:s'),
			);

			$insert_id = $this->videoModel->insert($insertData);

			if($insert_id)
			{
				$tags = json_decode($_POST['video_tags']);

				foreach($tags as $key => $val)
				{
					$insertTagData = array(
						'video_id' => $insert_id,
						'value' => $val->value,
						'date_created' => date('Y-m-d H:i:s'),
					);

					$this->tagsModel->insert($insertTagData);
				}

			}

			$this->session->setFlashdata('success_message', 'Record Added Successfully');
			return redirect()->to('video');
		}

		$category = $this->categoryModel->where(['status' => '1', 'is_deleted' => '0' ])->findAll();
		$subcategory = $this->subcategoryModel->where(['status' => '1', 'is_deleted' => '0' ])->findAll();

		return view('video/add', [
			'userData' => $this->session->userData,
			'category' => $category,
			'subcategory' => $subcategory
		]);
	}


	public function edit($id)
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		$id = base64_decode($id);

		if($this->request->getPost())
		{
			$this->tagsModel->where('video_id', $id)->set(['status' => '0'])->update();

			//insert here
			$updateData = array(
				'video_url' => $this->request->getPost('videourl'),
				'title' => $this->request->getPost('title'),
				'video_description' => $this->request->getPost('about_video'),
				'category_id' => $this->request->getPost('category'),
				'sub_category' => $this->request->getPost('sub_category'),
				'date_created' => date('Y-m-d H:i:s'),
			);

			$this->videoModel->update($id,$updateData);

			if($id)
			{
				$tags = json_decode($_POST['video_tags']);

				foreach($tags as $key => $val)
				{
					$insertTagData = array(
						'video_id' => $id,
						'value' => $val->value,
						'date_created' => date('Y-m-d H:i:s'),
					);

					$this->tagsModel->insert($insertTagData);
				}

			}

			$this->session->setFlashdata('success_message', 'Record Added Successfully');
			return redirect()->to('video');
		}

		$category = $this->categoryModel->where(['status' => '1', 'is_deleted' => '0' ])->findAll();
		$subcategory = $this->subcategoryModel->where(['status' => '1', 'is_deleted' => '0' ])->findAll();

		$gettags = $this->tagsModel->select('value')->where(['status' => '1', 'video_id' => $id ])->findAll();
		$record = $this->videoModel->find($id);


		return view('video/edit', [
			'userData' => $this->session->userData,
			'category' => $category,
			'subcategory' => $subcategory,
			'get_tags' => json_encode($gettags),
			'record' => $record
		]);
	}

	public function delete($id)
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		$id = base64_decode($id);
		$record = $this->videoModel->find($id);

		$updateData = array(
			'is_deleted' => '1'
		);

		$this->videoModel->update($id,$updateData);

		$this->session->setFlashdata('success_message', 'Record Updated Successfully');
		return redirect()->to('video');
		

	}

}
