<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use Auth\Models\UserModel;
use App\Models\SubcategoryModel;
use App\Models\CustomModel;

use \Hermawan\DataTables\DataTable;


class SubCategoryController extends Controller
{

	public function __construct()
	{
		// start session
		$this->session = Services::session();

		// load auth settings
		$this->config = config('Auth');

		$this->subcategoryModel = new SubcategoryModel();
		$this->customModel = new CustomModel();


	}

    //--------------------------------------------------------------------

	/**
	 * Displays account settings.
	 */
	public function index()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}


		$get_category_list = '';

		return view('subcategory/list', [
			'userData' => $this->session->userData,
		]);
	}


	public function listajaxDatatables()
	{
		$builder = $this->customModel->get_datatable_subcategory();
    
    	return DataTable::of($builder)
			->add('status', function($row){
        			$status = "Inactive";
        			if($row->status == '1')
        			{
        				$status = "Active";
        			}
        			
        			return $status;
    			})
			->add('action', function($row){
        			$action = '<a href="'.base_url('editsubcategory/' . base64_encode($row->id)).'">Edit</a>/';
        			$action .= '<a href="#" id="deletesubcategory" data-id="'.base64_encode($row->id).'">Delete</a>';
        			return $action;
    			})
			->addNumbering('no') 
    		->toJson(true);
	}


	public function add()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		

		if($this->request->getPost())
		{
			//insert here
			$getStatus = 0;
			if($this->request->getPost('status'))
			{
				$getStatus = 1;
			}

			$insertData = array(
				'sub_category_name' => $this->request->getPost('category'),
				'status' => $getStatus,
				'date_created' => date('Y-m-d H:i:s'),
			);

			$this->subcategoryModel->insert($insertData);

			$this->session->setFlashdata('success_message', 'Record Added Successfully');
			return redirect()->to('subcategory');
		}


		return view('subcategory/add', [
			'userData' => $this->session->userData,
		]);
	}

	public function edit($id)
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		$id = base64_decode($id);
		$record = $this->subcategoryModel->find($id);

		if($this->request->getPost())
		{
			//insert here
			$getStatus = 0;
			if($this->request->getPost('status'))
			{
				$getStatus = 1;
			}

			$updateData = array(
				'sub_category_name' => $this->request->getPost('category'),
				'status' => $getStatus,
			);

			$this->subcategoryModel->update($id,$updateData);

			$this->session->setFlashdata('success_message', 'Record Updated Successfully');
			return redirect()->to('subcategory');
		}


		return view('subcategory/edit', [
			'userData' => $this->session->userData,
			'record' => $record
		]);
	}


	public function delete($id)
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		$id = base64_decode($id);
		$record = $this->subcategoryModel->find($id);

		$updateData = array(
			'is_deleted' => '1'
		);

		$this->subcategoryModel->update($id,$updateData);

		$this->session->setFlashdata('success_message', 'Record Updated Successfully');
		return redirect()->to('subcategory');
		

	}

}
