<?php

/**
 * This file is part of the Nette Framework (https://nette.org)
 * Copyright (c) 2004 David Grudl (https://davidgrudl.com)
 */
declare (strict_types=1);
namespace RectorPrefix20211020\Nette;

/**
 * The exception that is thrown when the value of an argument is
 * outside the allowable range of values as defined by the invoked method.
 */
class ArgumentOutOfRangeException extends \InvalidArgumentException
{
}
/**
 * The exception that is thrown when a method call is invalid for the object's
 * current state, method has been invoked at an illegal or inappropriate time.
 */
class InvalidStateException extends \RuntimeException
{
}
/**
 * The exception that is thrown when a requested method or operation is not implemented.
 */
class NotImplementedException extends \LogicException
{
}
/**
 * The exception that is thrown when an invoked method is not supported. For scenarios where
 * it is sometimes possible to perform the requested operation, see InvalidStateException.
 */
class NotSupportedException extends \LogicException
{
}
/**
 * The exception that is thrown when a requested method or operation is deprecated.
 */
class DeprecatedException extends \RectorPrefix20211020\Nette\NotSupportedException
{
}
/**
 * The exception that is thrown when accessing a class member (property or method) fails.
 */
class MemberAccessException extends \Error
{
}
/**
 * The exception that is thrown when an I/O error occurs.
 */
class IOException extends \RuntimeException
{
}
/**
 * The exception that is thrown when accessing a file that does not exist on disk.
 */
class FileNotFoundException extends \RectorPrefix20211020\Nette\IOException
{
}
/**
 * The exception that is thrown when part of a file or directory cannot be found.
 */
class DirectoryNotFoundException extends \RectorPrefix20211020\Nette\IOException
{
}
/**
 * The exception that is thrown when an argument does not match with the expected value.
 */
class InvalidArgumentException extends \InvalidArgumentException
{
}
/**
 * The exception that is thrown when an illegal index was requested.
 */
class OutOfRangeException extends \OutOfRangeException
{
}
/**
 * The exception that is thrown when a value (typically returned by function) does not match with the expected value.
 */
class UnexpectedValueException extends \UnexpectedValueException
{
}
