<?php

namespace App\Models;

use CodeIgniter\Model;

class CustomModel extends Model
{
	public function __construct()
    {
        parent::__construct();
        $this->db = \Config\Database::connect();
    }

	
    public function getwhere_record($tablename='',$where=array())
    {
        $result = $this->db->table($tablename)->where($where)->get()->getResultArray();

        return $result;
    }

    public function insert_batch($tablename='', $data)
    {
        $this->db->table($tablename)->insertBatch($data);

    }

  

    public function get_datatable_category()
    {
        $query = $this->db->table('category as a')
        ->select('a.id,a.category_name,a.status')
        ->where('a.is_deleted', 0);

        return $query;
    }


    public function get_datatable_subcategory()
    {
        $query = $this->db->table('sub_category as a')
        ->select('a.id,a.sub_category_name,a.status')
        ->where('a.is_deleted', 0);

        return $query;
    }

    public function get_datatable_videolist()
    {
        $query = $this->db->table('video as a')
        ->select('a.id,a.video_url,a.title,a.video_description,a.category_id,a.sub_category,a.status,b.category_name,c.sub_category_name')
        ->join('category as b','b.id = a.category_id','left')
        ->join('sub_category as c','c.id = a.sub_category','left')
        ->where('a.is_deleted', 0);

        return $query;
    }

}
