<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use Auth\Models\UserModel;

class DashboardController extends Controller
{

	/**
	 * Access to current session.
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Authentication settings.
	 */
	protected $config;


    //--------------------------------------------------------------------

	public function __construct()
	{
		// start session
		$this->session = Services::session();

		// load auth settings
		$this->config = config('Auth');
	}

    //--------------------------------------------------------------------

	/**
	 * Displays account settings.
	 */
	public function index()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}

		return view('dashboard/home', [
			'userData' => $this->session->userData,
			'config' => $this->config
		]);
	}

}
